package ru.yandex.direct.core.entity.minuskeywordspack;

import java.math.BigInteger;
import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.utils.JsonUtils;

import static com.google.common.base.Preconditions.checkState;
import static java.util.Collections.emptyList;
import static org.springframework.util.CollectionUtils.isEmpty;
import static ru.yandex.direct.utils.HashingUtils.getMd5HalfHashUtf8;

public class MinusKeywordsPackUtils {

    /**
     * Преобразует список минус-фраз в json-массив, по которому считается хэш.
     *
     * @param minusKeywords список минус-фраз
     * @return json-массив, по которому считается хэш минус-фраз,
     * и в виде которого они хранятся в базе.
     */
    @Nullable
    public static String minusKeywordsToJson(@Nullable List<String> minusKeywords) {
        // обрабатываем дополнительно ситуацию пустого списка - явно записываем null в базу.
        return isEmpty(minusKeywords) ? null : JsonUtils.toJson(minusKeywords);
    }

    /**
     * @param minusKeywordsJson минус-фразы в виде json-массива
     * @return сет минус-фраз
     */
    @Nullable
    @SuppressWarnings("unchecked")
    public static List<String> minusKeywordsFromJson(@Nullable String minusKeywordsJson) {
        // Возможно стоит убрать проверку на пустую строку когда станет понятно кто пишет пустую строку
        // в camp_options.minus_words. Есть подозрение, что это делает Perl-ый код, так как текущий Java-ый пишет null
        // или валидный json
        return StringUtils.isNotEmpty(minusKeywordsJson)
                ? JsonUtils.fromJson(minusKeywordsJson, List.class)
                : emptyList();
    }

    /**
     * Вычисляет хэш от json-массива минус-фраз.
     *
     * @param minusKeywords непустой список минус-фраз
     * @return хэш от списка минус-фраз
     */
    public static BigInteger calcHash(List<String> minusKeywords) {
        checkState(!minusKeywords.isEmpty(), "для вычисления хеша список должен быть непустой");
        return getMd5HalfHashUtf8(minusKeywordsToJson(minusKeywords));
    }
}
