package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;

@Component
public class AddMinusKeywordsPackSubOperationFactory {

    private final MinusKeywordsPacksAddOperationFactory minusKeywordsPackSubOperationFactory;

    public AddMinusKeywordsPackSubOperationFactory(
            MinusKeywordsPacksAddOperationFactory minusKeywordsPackSubOperationFactory) {
        this.minusKeywordsPackSubOperationFactory = minusKeywordsPackSubOperationFactory;
    }

    public AddMinusKeywordsPackSubOperation newInstance(
            Applicability applicability,
            List<List<String>> minusKeywords,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            ClientId clientId,
            int shard) {
        return new AddMinusKeywordsPackSubOperation(
                applicability,
                minusKeywords,
                minusPhraseValidationMode,
                minusKeywordsPackSubOperationFactory,
                clientId,
                shard);
    }

    public <P extends Model> ItemSubOperationExecutor<P, List<String>, AddMinusKeywordsPackSubOperation> newExecutor(
            List<P> parents,
            ModelProperty<? super P, List<String>> parentMinusKeywordsProperty,
            Applicability applicability,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            ClientId clientId,
            int shard) {
        SubOperationCreator<List<String>, AddMinusKeywordsPackSubOperation> operationCreator =
                minusKeywordsLists -> newInstance(applicability, minusKeywordsLists, minusPhraseValidationMode,
                        clientId, shard);

        return ItemSubOperationExecutor.builder()
                .withFakeParents(parents)
                .withChildProperty(parentMinusKeywordsProperty)
                .withFiltering(parent -> CollectionUtils.isNotEmpty(parentMinusKeywordsProperty.get(parent)))
                .createSubOperationBy(operationCreator);
    }
}
