package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.service.MinusKeywordPreparingTool;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.container.AddedMinusKeywordsPackInfo;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.AddMinusKeywordsPackValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.ModelsPreValidatedStep;
import ru.yandex.direct.operation.add.ModelsValidatedStep;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class MinusKeywordsPacksAddOperation extends SimpleAbstractAddOperation<MinusKeywordsPack, AddedMinusKeywordsPackInfo> {

    private final AddMinusKeywordsPackValidationService addMinusKeywordsPackValidationService;
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;
    private final MinusKeywordsPackRepository packRepository;

    private final MinusPhraseValidator.ValidationMode minusPhraseValidationMode;
    private final boolean isPrivatePacks;
    private final ClientId clientId;
    private final int shard;

    MinusKeywordsPacksAddOperation(Applicability applicability, List<MinusKeywordsPack> models,
                                   AddMinusKeywordsPackValidationService addMinusKeywordsPackValidationService,
                                   MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
                                   MinusKeywordPreparingTool minusKeywordPreparingTool,
                                   MinusKeywordsPackRepository packRepository,
                                   ClientId clientId, int shard,
                                   boolean isPrivatePacks) {
        super(applicability, models);
        this.addMinusKeywordsPackValidationService = addMinusKeywordsPackValidationService;
        this.minusPhraseValidationMode = minusPhraseValidationMode;
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
        this.packRepository = packRepository;
        this.isPrivatePacks = isPrivatePacks;
        this.clientId = clientId;
        this.shard = shard;
    }

    public ValidationResult<List<MinusKeywordsPack>, Defect> getValidationResult() {
        return validationResult;
    }

    @Override
    protected ValidationResult<List<MinusKeywordsPack>, Defect> preValidate(List<MinusKeywordsPack> models) {
        return addMinusKeywordsPackValidationService
                .preValidate(models, minusPhraseValidationMode, isPrivatePacks, shard, clientId);
    }

    @Override
    protected void onPreValidated(ModelsPreValidatedStep<MinusKeywordsPack> modelsPreValidatedStep) {
        modelsPreValidatedStep.getPreValidModelsMap().values()
                .forEach(pack -> {
                    List<String> rawMinusKeywords = pack.getMinusKeywords();
                    List<String> readyMinusKeywords = minusKeywordPreparingTool.fullPrepareForSaving(rawMinusKeywords);
                    pack.setMinusKeywords(readyMinusKeywords);
                });
    }

    @Override
    protected void validate(ValidationResult<List<MinusKeywordsPack>, Defect> preValidationResult) {
        addMinusKeywordsPackValidationService.validate(preValidationResult, isPrivatePacks);
    }

    @Override
    protected void onModelsValidated(ModelsValidatedStep<MinusKeywordsPack> modelsValidatedStep) {
        modelsValidatedStep.getModels().forEach(pack -> pack.withIsLibrary(!isPrivatePacks));
    }

    @Override
    protected List<AddedMinusKeywordsPackInfo> execute(List<MinusKeywordsPack> validModelsToApply) {
        List<Long> addedMinusKeywordsPackIds;
        if (isPrivatePacks) {
            addedMinusKeywordsPackIds =
                    packRepository.createPrivateMinusKeywords(shard, clientId, validModelsToApply);
        } else {
            addedMinusKeywordsPackIds =
                    packRepository.createLibraryMinusKeywords(shard, clientId, validModelsToApply);
        }
        return createResultInfo(validModelsToApply, addedMinusKeywordsPackIds);
    }

    private List<AddedMinusKeywordsPackInfo> createResultInfo(List<MinusKeywordsPack> minusKeywordsPacksToAdd,
                                                              List<Long> savedMinusKeywordsPackIds) {
        return StreamEx.zip(minusKeywordsPacksToAdd, savedMinusKeywordsPackIds,
                (mkPack, mkPackId) -> new AddedMinusKeywordsPackInfo()
                        .withId(mkPackId)
                        .withName(mkPack.getName())
                        .withMinusKeywords(mkPack.getMinusKeywords()))
                .toList();
    }
}
