package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.service.MinusKeywordPreparingTool;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.AddMinusKeywordsPackValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;

@Component
public class MinusKeywordsPacksAddOperationFactory {

    private final AddMinusKeywordsPackValidationService addMinusKeywordsPackValidationService;
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;
    private final MinusKeywordsPackRepository packRepository;

    @Autowired
    public MinusKeywordsPacksAddOperationFactory(
            AddMinusKeywordsPackValidationService addMinusKeywordsPackValidationService,
            MinusKeywordPreparingTool minusKeywordPreparingTool,
            MinusKeywordsPackRepository packRepository) {
        this.addMinusKeywordsPackValidationService = addMinusKeywordsPackValidationService;
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
        this.packRepository = packRepository;
    }

    public MinusKeywordsPacksAddOperation newInstance(
            Applicability applicability,
            List<MinusKeywordsPack> models,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            ClientId clientId, int shard, boolean isPrivatePacks) {

        return new MinusKeywordsPacksAddOperation(
                applicability,
                models,
                addMinusKeywordsPackValidationService,
                minusPhraseValidationMode,
                minusKeywordPreparingTool,
                packRepository,
                clientId, shard, isPrivatePacks);
    }

}
