package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.DeleteMinusKeywordsPackValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.operationwithid.AbstractOperationWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Операция удаления библиотечного элемента минус фраз (частные наборы удалению не подлежат)
 */
public class MinusKeywordsPacksDeleteOperation extends AbstractOperationWithId {
    private final DeleteMinusKeywordsPackValidationService validationService;
    private final MinusKeywordsPackRepository packRepository;
    private final ClientId clientId;
    private final int shard;

    MinusKeywordsPacksDeleteOperation(Applicability applicability, List<Long> modelIds,
                                      DeleteMinusKeywordsPackValidationService validationService,
                                      MinusKeywordsPackRepository packRepository,
                                      ClientId clientId,
                                      int shard) {
        super(applicability, modelIds);
        this.validationService = validationService;
        this.packRepository = packRepository;
        this.clientId = clientId;
        this.shard = shard;
    }

    @Override
    protected ValidationResult<List<Long>, Defect> validate(List<Long> ids) {
        return validationService.validateDelete(shard, clientId, ids);
    }

    @Override
    protected void execute(List<Long> ids) {
        packRepository.delete(shard, clientId, ids);
    }
}
