package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.DeleteMinusKeywordsPackValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;

@Component
public class MinusKeywordsPacksDeleteOperationFactory {

    private final DeleteMinusKeywordsPackValidationService validationService;
    private final MinusKeywordsPackRepository packRepository;

    @Autowired
    public MinusKeywordsPacksDeleteOperationFactory(
            DeleteMinusKeywordsPackValidationService validationService,
            MinusKeywordsPackRepository packRepository) {
        this.validationService = validationService;
        this.packRepository = packRepository;
    }

    public MinusKeywordsPacksDeleteOperation newInstance(Applicability applicability, List<Long> modelIds,
                                                         ClientId clientId, int shard) {
        return new MinusKeywordsPacksDeleteOperation(applicability, modelIds, validationService, packRepository,
                clientId, shard);
    }
}
