package ru.yandex.direct.core.entity.minuskeywordspack.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.MinusKeywordPreparingTool;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.UpdateMinusKeywordsPackValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
public class MinusKeywordsPacksUpdateOperationFactory {

    private final DslContextProvider dslContextProvider;
    private final MinusKeywordsPackRepository minusKeywordsPackRepository;
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;
    private final UpdateMinusKeywordsPackValidationService validationService;
    private final AdGroupRepository adGroupRepository;
    private final CampaignRepository campaignRepository;
    private final BannerCommonRepository bannerCommonRepository;

    @Autowired
    public MinusKeywordsPacksUpdateOperationFactory(DslContextProvider dslContextProvider,
                                                    MinusKeywordsPackRepository minusKeywordsPackRepository,
                                                    MinusKeywordPreparingTool minusKeywordPreparingTool,
                                                    UpdateMinusKeywordsPackValidationService validationService,
                                                    AdGroupRepository adGroupRepository,
                                                    CampaignRepository campaignRepository,
                                                    BannerCommonRepository bannerCommonRepository) {
        this.dslContextProvider = dslContextProvider;
        this.minusKeywordsPackRepository = minusKeywordsPackRepository;
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
        this.validationService = validationService;
        this.adGroupRepository = adGroupRepository;
        this.campaignRepository = campaignRepository;
        this.bannerCommonRepository = bannerCommonRepository;
    }

    public MinusKeywordsPacksUpdateOperation newInstance(
            Applicability applicability,
            List<ModelChanges<MinusKeywordsPack>> modelsChanges,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            ClientId clientId, int shard) {

        return new MinusKeywordsPacksUpdateOperation(
                applicability,
                modelsChanges,
                dslContextProvider,
                minusKeywordsPackRepository,
                minusKeywordPreparingTool,
                validationService,
                adGroupRepository,
                campaignRepository,
                bannerCommonRepository,
                minusPhraseValidationMode,
                clientId,
                shard);
    }

}
