package ru.yandex.direct.core.entity.minuskeywordspack.service.validation;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefects;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notInSet;

@Service
public class DeleteMinusKeywordsPackValidationService {
    private final MinusKeywordsPackRepository packRepository;

    @Autowired
    public DeleteMinusKeywordsPackValidationService(
            MinusKeywordsPackRepository packRepository) {
        this.packRepository = packRepository;
    }

    /**
     * Проверить, что: набор библиотечный, принадлежит текущему пользователю и никуда не привязан.
     *
     * @param shard    - шард
     * @param clientId - клиент
     * @param mwIds    - набор идентификаторов библиотечных минус фраз
     * @return - результат валидации
     */
    public ValidationResult<List<Long>, Defect> validateDelete(int shard, ClientId clientId, List<Long> mwIds) {
        Set<Long> existingIds = packRepository.getClientExistingLibraryMinusKeywordsPackIds(shard, clientId, mwIds);
        Set<Long> linkedIds = packRepository.getLibraryPackIdsWithLinks(shard, mwIds);

        return ListValidationBuilder.<Long, Defect>of(mwIds)
                .checkEach(inSet(existingIds), MinusPhraseDefects.minusWordsPackNotFound(), When.isValid())
                .checkEach(notInSet(linkedIds), CommonDefects.unableToDelete(), When.isValid())
                .getResult();
    }
}
