package ru.yandex.direct.core.entity.minuskeywordspack.service.validation;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.common.util.TextUtils.smartStrip;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.GROUP_MINUS_KEYWORDS_MAX_LENGTH;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxLengthKeywordsWithoutSpecSymbolsAndSpaces;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxWordsInKeywords;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.admissibleChars;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Service
public class MinusKeywordsPackValidationService {
    public static final int MAX_NAME_LENGTH = 255;

    ValidationResult<MinusKeywordsPack, Defect> validatePack(MinusKeywordsPack minusKeywordsPack,
                                                             boolean isPrivatePacks) {
        ModelItemValidationBuilder<MinusKeywordsPack> vb = ModelItemValidationBuilder.of(minusKeywordsPack);

        ItemValidationBuilder<String, Defect> packNameVb =
                vb.item(smartStrip(minusKeywordsPack.getName()), MinusKeywordsPack.NAME.name());
        if (isPrivatePacks) {
            packNameVb.check(isNull());
        } else {
            packNameVb
                    .check(notNull())
                    .check(notBlank())
                    .check(maxStringLength(MAX_NAME_LENGTH))
                    .check(admissibleChars());
        }

        vb.item(MinusKeywordsPack.MINUS_KEYWORDS)
                .check(notNull())
                .check(notEmptyCollection())
                .check(maxLengthKeywordsWithoutSpecSymbolsAndSpaces(GROUP_MINUS_KEYWORDS_MAX_LENGTH))
                .check(maxWordsInKeywords());

        return vb.getResult();
    }

}
