package ru.yandex.direct.core.entity.misprints

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppcdict.tables.MisprintsFixlist.MISPRINTS_FIXLIST
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapperhelper.InsertHelper

@Repository
open class MisprintFixlistRepository(private val dslContextProvider: DslContextProvider) {

    fun insertMisprints(misprintsToInsert: List<String>) {
        if (misprintsToInsert.isNotEmpty()) {
            val insertHelper = InsertHelper(dslContextProvider.ppcdict(), MISPRINTS_FIXLIST)
            misprintsToInsert.forEach { s ->
                insertHelper.set(MISPRINTS_FIXLIST.MISPRINT, s).newRecord()
            }
            insertHelper.execute()
        }
    }

    fun deleteMisprints(misprintsToDelete: List<String>) {
        if (misprintsToDelete.isNotEmpty()) {
            dslContextProvider.ppcdict()
                    .deleteFrom(MISPRINTS_FIXLIST)
                    .where(MISPRINTS_FIXLIST.MISPRINT.`in`(misprintsToDelete))
                    .execute()
        }
    }

    fun getMisprints(): List<String> {
        return dslContextProvider.ppcdict().select(MISPRINTS_FIXLIST.MISPRINT)
                .from(MISPRINTS_FIXLIST)
                .fetch(MISPRINTS_FIXLIST.MISPRINT)
    }

}
