package ru.yandex.direct.core.entity.misprints

import com.google.common.base.Supplier
import com.google.common.base.Suppliers
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import java.util.concurrent.TimeUnit
import javax.annotation.ParametersAreNonnullByDefault

@Service
@ParametersAreNonnullByDefault
class MisprintFixlistService constructor(
        @Autowired private val misprintFixlistRepository: MisprintFixlistRepository,
        val supplier: Supplier<List<String>> = Suppliers
                .memoizeWithExpiration({ misprintFixlistRepository.getMisprints() }, 1, TimeUnit.DAYS)) {

    //В базе лежит не более 5000 строк(на самом деле около 1000), каждая — одно слово, памяти хватит  
    fun getMisprints(): List<String> {
        return supplier.get()
    }

}
