package ru.yandex.direct.core.entity.mobileapp;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerUrlParameter;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerUrlTemplate;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.types.DummyTranslatable;

import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.ADJUST;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.ADJUSTUL;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.APPMETRICA;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.APPMETRICAUL;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.APPSFLYER;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.APPSFLYERUL;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.BRANCH;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.FLURRY;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.KOCHAVA;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.MAIL_RU;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.OTHER;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.SINGULAR;
import static ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerTrackingSystem.TUNE;

public class Constants {
    @SuppressWarnings("SpellCheckingInspection")
    public static final Map<MobileAppTrackerTrackingSystem, Translatable> TRACKER_NAMES =
            ImmutableMap.<MobileAppTrackerTrackingSystem, Translatable>builder()
                    .put(OTHER, translations().other())
                    .put(APPMETRICA, new DummyTranslatable("AppMetrica"))
                    .put(ADJUST, new DummyTranslatable("Adjust"))
                    .put(APPSFLYER, new DummyTranslatable("Appsflyer"))
                    .put(TUNE, new DummyTranslatable("TUNE"))
                    .put(MAIL_RU, new DummyTranslatable("Mail.ru"))
                    .put(FLURRY, new DummyTranslatable("Flurry"))
                    .put(KOCHAVA, new DummyTranslatable("Kochava"))
                    .put(SINGULAR, new DummyTranslatable("Singular"))
                    .put(APPMETRICAUL, new DummyTranslatable("AppMetricaUL"))
                    .put(ADJUSTUL, new DummyTranslatable("AdjustUL"))
                    .put(APPSFLYERUL, new DummyTranslatable("AppsflyerUL"))
                    .put(BRANCH, new DummyTranslatable("Branch"))
                    .build();

    private static MobileAppTrackerUrlTemplate createAdjustUrlTemplate(String baseUrlTemplate) {
        return MobileAppTrackerUrlTemplate.builder()
                .withTrackingSystem(ADJUST, TRACKER_NAMES.get(ADJUST))
                .withBaseUrlTemplate(baseUrlTemplate)
                .withParameters(ImmutableList.of(
                        MobileAppTrackerUrlParameter.builder()
                                .withName("idfa")
                                .withValue("{ios_ifa}")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("gps_adid")
                                .withValue("{google_aid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("oaid")
                                .withValue("{oaid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("campaign")
                                .withDescription(translations().campaignNameLat())
                                .withValue("{campaign_id}_{campaign_name_lat}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("adgroup")
                                .withDescription(translations().adGroupIdentifier())
                                .withValue("{gbid}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("creative")
                                .withDescription(translations().adOrKeywordOrRetargetingCondition())
                                .withValue("{ad_id}_{phrase_id}{retargeting_id}_{keyword}{adtarget_name}")
                                .build()
                ))
                .build();
    }

    private static MobileAppTrackerUrlTemplate createAppsflyerUrlTemplate(String baseUrlTemplate) {
        return MobileAppTrackerUrlTemplate.builder()
                .withTrackingSystem(APPSFLYER, TRACKER_NAMES.get(APPSFLYER))
                .withBaseUrlTemplate(baseUrlTemplate)
                .withParameters(ImmutableList.of(
                        MobileAppTrackerUrlParameter.builder()
                                .withName("idfa")
                                .withValue("{ios_ifa}")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("advertising_id")
                                .withValue("{google_aid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("oaid")
                                .withValue("{oaid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("is_retargeting")
                                .withValue("true")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("c")
                                .withDescription(translations().campaignNameLat())
                                .withValue("{campaign_name_lat}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("af_c_id")
                                .withDescription(translations().campaignIdentifier())
                                .withValue("{campaign_id}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("af_adset_id")
                                .withDescription(translations().adGroupIdentifier())
                                .withValue("{gbid}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("af_ad_id")
                                .withDescription(translations().adIdentifier())
                                .withValue("{ad_id}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("af_keywords")
                                .withDescription(translations().keywords())
                                .withValue("{phrase_id}{retargeting_id}_{keyword}{adtarget_name}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("af_siteid")
                                .withDescription(translations().site())
                                .withValue("{source_type}_{source}")
                                .build()
                ))
                .build();
    }

    private static MobileAppTrackerUrlTemplate createKochavaUrlTemplate(String baseUrlTemplate) {
        return MobileAppTrackerUrlTemplate.builder()
                .withTrackingSystem(KOCHAVA, TRACKER_NAMES.get(KOCHAVA))
                .withBaseUrlTemplate(baseUrlTemplate)
                .withParameters(ImmutableList.of(
                        MobileAppTrackerUrlParameter.builder()
                                .withName("network_id")
                                .withValue("1516")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("device_id_type")
                                .withValue("idfa")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("idfa")
                                .withValue("{ios_ifa}")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("device_id")
                                .withValue("{ios_ifa}")
                                .withOsType(OsType.IOS)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("network_id")
                                .withValue("1517")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("device_id_type")
                                .withValue("adid")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("adid")
                                .withValue("{google_aid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("device_id")
                                .withValue("{google_aid}")
                                .withOsType(OsType.ANDROID)
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("site_id")
                                .withDescription(translations().site())
                                .withValue("{source_type}_{source}")
                                .build(),
                        MobileAppTrackerUrlParameter.builder()
                                .withName("creative_id")
                                .withDescription(translations().adOrKeywordOrRetargetingCondition())
                                .withValue("{ad_id}_{phrase_id}{retargeting_id}_{keyword}{adtarget_name}")
                                .build()
                ))
                .build();
    }

    public static final Map<MobileAppTrackerTrackingSystem, MobileAppTrackerUrlTemplate> TRACKING_SYSTEMS_CLICK_DESC =
            ImmutableMap.<MobileAppTrackerTrackingSystem, MobileAppTrackerUrlTemplate>builder()
                    .put(OTHER, MobileAppTrackerUrlTemplate.builder()
                            .withTrackingSystem(OTHER, TRACKER_NAMES.get(OTHER))
                            .withBaseUrlTemplate("")
                            .withParameters(Collections.emptyList())
                            .build())
                    .put(ADJUST, createAdjustUrlTemplate("https://app.adjust.com/${tracker_id}?"))
                    .put(APPSFLYER, createAppsflyerUrlTemplate("https://app.appsflyer.com/${tracker_id}?pid=yandexdirect_int&clickid={logid}"))
                    .put(FLURRY, MobileAppTrackerUrlTemplate.builder()
                            .withTrackingSystem(FLURRY, TRACKER_NAMES.get(FLURRY))
                            .withBaseUrlTemplate("https://ad.apps.fm/${tracker_id}?reqid={logid}")
                            .withParameters(ImmutableList.of(
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("ios_ifa")
                                            .withValue("{ios_ifa}")
                                            .withOsType(OsType.IOS)
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("google_aid")
                                            .withValue("{google_aid}")
                                            .withOsType(OsType.ANDROID)
                                            .build()
                            ))
                            .build())
                    .put(APPMETRICA, MobileAppTrackerUrlTemplate.builder()
                            .withTrackingSystem(APPMETRICA, TRACKER_NAMES.get(APPMETRICA))
                            .withBaseUrlTemplate(
                                    "https://redirect.appmetrica.yandex.com/serve/${tracker_id}?click_id={logid}")
                            .withParameters(ImmutableList.of(
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("ios_ifa")
                                            .withValue("{ios_ifa}")
                                            .withOsType(OsType.IOS)
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("google_aid")
                                            .withValue("{google_aid}")
                                            .withOsType(OsType.ANDROID)
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("c")
                                            .withDescription(translations().campaignNameLat())
                                            .withValue("{campaign_id}_{campaign_name_lat}")
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("adgroup_id")
                                            .withDescription(translations().adGroupIdentifier())
                                            .withValue("{gbid}")
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("creative_id")
                                            .withDescription(translations().adIdentifier())
                                            .withValue("{ad_id}")
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("criteria")
                                            .withDescription(translations().keywordOrRetargetingCondition())
                                            .withValue("{phrase_id}{retargeting_id}_{keyword}{adtarget_name}")
                                            .build(),
                                    MobileAppTrackerUrlParameter.builder()
                                            .withName("site_id")
                                            .withDescription(translations().site())
                                            .withValue("{source_type}_{source}")
                                            .build()
                            ))
                            .build())
                    .put(KOCHAVA, createKochavaUrlTemplate("https://control.kochava.com/v1/cpi/click?campaign_id=${tracker_id}&click_id={logid}"))
                    .build();

    public static final Map<MobileAppTrackerTrackingSystem, MobileAppTrackerUrlTemplate> TRACKING_SYSTEMS_IMPRESSION_DESC =
            ImmutableMap.<MobileAppTrackerTrackingSystem, MobileAppTrackerUrlTemplate>builder()
                    .put(OTHER, MobileAppTrackerUrlTemplate.builder()
                            .withTrackingSystem(OTHER, TRACKER_NAMES.get(OTHER))
                            .withBaseUrlTemplate("")
                            .withParameters(Collections.emptyList())
                            .build())
                    .put(ADJUST, createAdjustUrlTemplate("https://view.adjust.com/impression/${tracker_id}?s2s=1&"))
                    .put(APPSFLYER, createAppsflyerUrlTemplate("https://impression.appsflyer.com/${tracker_id}?pid=yandexdirect_int&clickid={logid}"))
                    .put(KOCHAVA, createKochavaUrlTemplate("https://imp.control.kochava.com/track/impression?event=view&campaign_id=${tracker_id}&impression_id={logid}"))
                    .build();

    public static final List<MobileAppTrackerUrlTemplate> TRACKING_SYSTEMS_CLICK = ImmutableList.copyOf(
            TRACKING_SYSTEMS_CLICK_DESC.values());
    public static final List<MobileAppTrackerUrlTemplate> TRACKING_SYSTEMS_IMPRESSION = ImmutableList.copyOf(
            TRACKING_SYSTEMS_IMPRESSION_DESC.values());

    private static MobileAppTranslations translations() {
        return MobileAppTranslations.INSTANCE;
    }
}
