package ru.yandex.direct.core.entity.mobileapp;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobileapp.model.MobileAppStoreType;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

@ParametersAreNonnullByDefault
@Component
public class MobileAppConverter {
    public MobileAppStoreType osTypeToStoreType(OsType osType) {
        switch (osType) {
            case ANDROID:
                return MobileAppStoreType.GOOGLEPLAYSTORE;
            case IOS:
                return MobileAppStoreType.APPLEAPPSTORE;
            default:
                throw new IllegalStateException("unknown os type");
        }
    }
}
