package ru.yandex.direct.core.entity.mobileapp;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class MobileAppDefects {
    public static Defect<Void> noAccessToChangeDomain() {
        return new Defect<>(Gen.NO_ACCESS_TO_CHANGE_DOMAIN);
    }

    public static Defect<Void> invalidUrl() {
        return new Defect<>(Gen.INVALID_URL);
    }

    public static Defect<Void> invalidAppStoreUrl() {
        return new Defect<>(Gen.INVALID_APP_STORE_URL);
    }

    public static Defect<Void> invalidDomain() {
        return new Defect<>(Gen.INVALID_DOMAIN);
    }

    public static Defect<Void> trackerUrlDomainDoesNotMatchSelectedTrackerSystem() {
        return new Defect<>(Gen.TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM);
    }

    public static Defect<Void> appNotFound() {
        return new Defect<>(Gen.APP_NOT_FOUND);
    }

    public static Defect<Void> tooManyBanners() {
        return new Defect<>(Gen.TOO_MANY_BANNERS);
    }

    public static Defect<Void> propagationIsFailed() {
        return new Defect<>(Gen.PROPAGATION_IS_FAILED);
    }

    public static Defect<Void> canNotRemoveTrackingUrlInCpiCampaign() {
        return new Defect<>(Gen.CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN);
    }

    public static Defect<Void> canNotChangeTrackingSystemInCpiCampaign() {
        return new Defect<>(Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN);
    }

    public static Defect<Void> canNotChangeTrackingSystemWithUntrackableBannerHref() {
        return new Defect<>(Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF);
    }

    public static Defect<Void> appMetrikaApplicationAlreadyUsed() {
        return new Defect<>(Gen.APPMETRIKA_APPLICATION_ALREADY_USED);
    }

    public enum Gen implements DefectId<Void> {
        NO_ACCESS_TO_CHANGE_DOMAIN,
        INVALID_URL,
        INVALID_APP_STORE_URL,
        INVALID_DOMAIN,
        TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM,
        APP_NOT_FOUND,
        TOO_MANY_BANNERS,
        PROPAGATION_IS_FAILED,
        CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN,
        CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN,
        CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF,
        APPMETRIKA_APPLICATION_ALREADY_USED,
    }
}
