package ru.yandex.direct.core.entity.mobileapp;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface MobileAppTranslations extends TranslationBundle {
    MobileAppTranslations INSTANCE = I18NBundle.implement(MobileAppTranslations.class);

    @TranslationStub("Другое")
    Translatable other();

    @TranslationStub("Название кампании (латиницей)")
    Translatable campaignNameLat();

    @TranslationStub("Объявление, ключевое слово или условие ретаргетинга")
    Translatable adOrKeywordOrRetargetingCondition();

    @TranslationStub("Ключевое слово или условие ретаргетинга")
    Translatable keywordOrRetargetingCondition();

    @TranslationStub("Идентификатор кампании")
    Translatable campaignIdentifier();

    @TranslationStub("Идентификатор группы объявлений")
    Translatable adGroupIdentifier();

    @TranslationStub("Идентификатор объявления")
    Translatable adIdentifier();

    @TranslationStub("Ключевые слова")
    Translatable keywords();

    @TranslationStub("Сайт сети, где был показ (место показа)")
    Translatable site();

    @TranslationStub("Изменение домена не доступно")
    Translatable noAccessToChangeDomain();

    @TranslationStub("Неправильный формат ссылки")
    Translatable invalidUrl();

    @TranslationStub("Неправильный формат ссылки на приложение")
    Translatable invalidAppStoreUrl();

    @TranslationStub("Неправильный формат домена")
    Translatable invalidDomain();

    @TranslationStub("Домен трекинговой ссылки не соответствует выбранной трекинговой системе")
    Translatable trackerUrlDomainDoesNotMatchSelectedTrackerSystem();

    @TranslationStub("Указанное приложение не найдено")
    Translatable appNotFound();

    @TranslationStub("Слишком много объявлений для обновления в выбранном режиме")
    Translatable tooManyBanners();

    @TranslationStub("Обновление объявлений не прошло проверку корректности")
    Translatable propagationIsFailed();

    @TranslationStub("Невозможно удалить трекинговую ссылку в объявлении кампании с CPI стратегией")
    Translatable canNotRemoveTrackingUrlInCpiCampaign();

    @TranslationStub("Выбранное приложение аппметрики уже используется")
    Translatable appMetrikaApplicationAlreadyUsed();
}
