package ru.yandex.direct.core.entity.mobileapp.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;

@ParametersAreNonnullByDefault
public class MobileAppAutomaticCreationRequestWithSuppliedMobileContent {
    private final MobileContent mobileContent;

    private final String storeHref;

    @Nullable
    private final String minimalOperatingSystemVersion;

    @Nullable
    private final String trackerUrl;

    @Nullable
    private final String impressionUrl;

    public MobileAppAutomaticCreationRequestWithSuppliedMobileContent(MobileContent mobileContent, String storeHref,
                                                                      @Nullable String minimalOperatingSystemVersion,
                                                                      @Nullable String trackerUrl,
                                                                      @Nullable String impressionUrl) {
        this.mobileContent = mobileContent;
        this.storeHref = storeHref;
        this.minimalOperatingSystemVersion = minimalOperatingSystemVersion;
        this.trackerUrl = trackerUrl;
        this.impressionUrl = impressionUrl;
    }

    public MobileContent getMobileContent() {
        return mobileContent;
    }

    public String getStoreHref() {
        return storeHref;
    }

    @Nullable
    public String getMinimalOperatingSystemVersion() {
        return minimalOperatingSystemVersion;
    }

    @Nullable
    public String getTrackerUrl() {
        return trackerUrl;
    }

    @Nullable
    public String getImpressionUrl() {
        return impressionUrl;
    }

    @Override
    public String toString() {
        return "MobileAppAutomaticCreationRequestWithSuppliedMobileContent{" +
                "mobileContent=" + mobileContent +
                ", storeHref='" + storeHref + '\'' +
                ", minimalOperatingSystemVersion='" + minimalOperatingSystemVersion + '\'' +
                ", trackerUrl='" + trackerUrl + '\'' +
                ", impressionUrl='" + impressionUrl + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MobileAppAutomaticCreationRequestWithSuppliedMobileContent that =
                (MobileAppAutomaticCreationRequestWithSuppliedMobileContent) o;
        return Objects.equals(mobileContent, that.mobileContent) &&
                Objects.equals(storeHref, that.storeHref) &&
                Objects.equals(minimalOperatingSystemVersion, that.minimalOperatingSystemVersion) &&
                Objects.equals(trackerUrl, that.trackerUrl) &&
                Objects.equals(impressionUrl, that.impressionUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mobileContent, storeHref, minimalOperatingSystemVersion, trackerUrl, impressionUrl);
    }
}
