package ru.yandex.direct.core.entity.mobileapp.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.mobilecontent.container.MobileAppStoreUrl;
import ru.yandex.direct.core.entity.mobilecontent.util.MobileAppStoreUrlParser;

@ParametersAreNonnullByDefault
public class MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent {
    private final MobileAppStoreUrl parsedStoreHref;

    private final String storeHref;

    @Nullable
    private final String minimalOperatingSystemVersion;

    @Nullable
    private final String trackerUrl;

    @Nullable
    private final String impressionUrl;

    public MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent(MobileAppStoreUrl parsedStoreHref,
                                                                         String storeHref,
                                                                         @Nullable String minimalOperatingSystemVersion,
                                                                         @Nullable String trackerUrl,
                                                                         @Nullable String impressionUrl) {
        this.parsedStoreHref = parsedStoreHref;
        this.storeHref = storeHref;
        this.minimalOperatingSystemVersion = minimalOperatingSystemVersion;
        this.trackerUrl = trackerUrl;
        this.impressionUrl = impressionUrl;
    }

    public MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent(String storeHref,
                                                                         @Nullable String minimalOperatingSystemVersion,
                                                                         @Nullable String trackerUrl,
                                                                         @Nullable String impressionUrl) {
        this.parsedStoreHref = MobileAppStoreUrlParser.parseStrict(storeHref);
        this.storeHref = storeHref;
        this.minimalOperatingSystemVersion = minimalOperatingSystemVersion;
        this.trackerUrl = trackerUrl;
        this.impressionUrl = impressionUrl;
    }

    public MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent(String storeHref,
                                                                        @Nullable String trackerUrl,
                                                                        @Nullable String impressionUrl) {
        this(storeHref, null, trackerUrl, impressionUrl);
    }

    public MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent(String storeHref) {
        this(storeHref, null, null);
    }

    public MobileAppStoreUrl getParsedStoreHref() {
        return parsedStoreHref;
    }

    public String getStoreHref() {
        return storeHref;
    }

    @Nullable
    public String getMinimalOperatingSystemVersion() {
        return minimalOperatingSystemVersion;
    }

    @Nullable
    public String getTrackerUrl() {
        return trackerUrl;
    }

    @Nullable
    public String getImpressionUrl() {
        return impressionUrl;
    }

    @Override
    public String toString() {
        return "MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent{" +
                "parsedStoreHref=" + parsedStoreHref +
                ", storeHref='" + storeHref + '\'' +
                ", minimalOperatingSystemVersion='" + minimalOperatingSystemVersion + '\'' +
                ", trackerUrl='" + trackerUrl + '\'' +
                ", impressionUrl='" + impressionUrl + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent that =
                (MobileAppAutomaticCreationRequestWithoutSuppliedMobileContent) o;
        return Objects.equals(parsedStoreHref, that.parsedStoreHref) &&
                Objects.equals(storeHref, that.storeHref) &&
                Objects.equals(minimalOperatingSystemVersion, that.minimalOperatingSystemVersion) &&
                Objects.equals(trackerUrl, that.trackerUrl) &&
                Objects.equals(impressionUrl, that.impressionUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parsedStoreHref, storeHref, minimalOperatingSystemVersion, trackerUrl, impressionUrl);
    }
}
