package ru.yandex.direct.core.entity.mobileapp.model;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.i18n.Translatable;

import static com.google.common.base.Preconditions.checkNotNull;

@SuppressWarnings("WeakerAccess")
public class MobileAppTrackerUrlParameter {
    private final String name;

    @Nullable
    private final Translatable description;

    private final String value;

    // если поле не null, значит этот параметр должен быть обязательно применён к для указаной ОС
    @Nullable
    private final OsType osType;

    public MobileAppTrackerUrlParameter(String name, @Nullable Translatable description, String value,
                                        @Nullable OsType osType) {
        this.name = name;
        this.description = description;
        this.value = value;
        this.osType = osType;
    }

    public String getName() {
        return name;
    }

    @Nullable
    public Translatable getDescription() {
        return description;
    }

    public String getValue() {
        return value;
    }

    @Nullable
    public OsType getOsType() {
        return osType;
    }

    public boolean isRequired() {
        return osType != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressWarnings("unused")
    public static final class Builder {
        private String name;
        private Translatable description;
        private String value;
        private OsType osType;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(@Nullable Translatable description) {
            this.description = description;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withOsType(@Nullable OsType osType) {
            this.osType = osType;
            return this;
        }

        public MobileAppTrackerUrlParameter build() {
            return new MobileAppTrackerUrlParameter(checkNotNull(name), description, checkNotNull(value), osType);
        }
    }
}
