package ru.yandex.direct.core.entity.mobileapp.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.i18n.Translatable;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class MobileAppTrackerUrlTemplate {
    private final MobileAppTrackerTrackingSystem trackingSystem;
    private final Translatable trackingSystemName;

    // шаблон, куда должен подставиться trackerId и, обычно, в нём должен быть параметр {logid}
    private final String baseUrlTemplate;

    // тут может быть пустой список
    private final List<MobileAppTrackerUrlParameter> parameters;

    @SuppressWarnings("WeakerAccess")
    public MobileAppTrackerUrlTemplate(MobileAppTrackerTrackingSystem trackingSystem, Translatable trackingSystemName,
                                       String baseUrlTemplate, List<MobileAppTrackerUrlParameter> parameters) {
        this.trackingSystem = trackingSystem;
        this.trackingSystemName = trackingSystemName;
        this.baseUrlTemplate = baseUrlTemplate;
        this.parameters = parameters;
    }


    public MobileAppTrackerTrackingSystem getTrackingSystem() {
        return trackingSystem;
    }

    public Translatable getTrackingSystemName() {
        return trackingSystemName;
    }

    public String getBaseUrlTemplate() {
        return baseUrlTemplate;
    }

    public List<MobileAppTrackerUrlParameter> getParameters() {
        return parameters;
    }

    public boolean isEditable() {
        return baseUrlTemplate.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressWarnings("unused")
    @ParametersAreNonnullByDefault
    public static final class Builder {
        private MobileAppTrackerTrackingSystem trackingSystem;
        private Translatable trackingSystemName;
        private String baseUrlTemplate;
        private List<MobileAppTrackerUrlParameter> parameters;

        private Builder() {
        }

        public Builder withTrackingSystem(MobileAppTrackerTrackingSystem trackingSystem,
                                          Translatable trackingSystemName) {
            this.trackingSystem = trackingSystem;
            this.trackingSystemName = trackingSystemName;
            return this;
        }

        public Builder withBaseUrlTemplate(String baseUrlTemplate) {
            this.baseUrlTemplate = baseUrlTemplate;
            return this;
        }

        public Builder withParameters(List<MobileAppTrackerUrlParameter> parameters) {
            this.parameters = ImmutableList.copyOf(parameters);
            return this;
        }

        public MobileAppTrackerUrlTemplate build() {
            return new MobileAppTrackerUrlTemplate(
                    checkNotNull(trackingSystem), checkNotNull(trackingSystemName), checkNotNull(baseUrlTemplate),
                    checkNotNull(parameters));
        }
    }
}
