package ru.yandex.direct.core.entity.mobileapp.repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;


@ParametersAreNonnullByDefault
public class MobileAppMappings {
    static List<String> userParamsFromJson(@Nullable String json) {
        if (isBlank(json)) {
            return Collections.emptyList();
        }
        return Arrays.asList(fromJson(json, String[].class));
    }

    @Nullable
    static String userParamsToJson(@Nullable List<String> userParams) {
        if (userParams == null || userParams.isEmpty()) {
            return null;
        }
        return toJson(userParams);
    }
}
