package ru.yandex.direct.core.entity.mobileapp.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.copyentity.RelationshipService
import ru.yandex.direct.core.entity.campaign.model.CampaignLinkedToMobileApp
import ru.yandex.direct.dbutil.model.ClientId

@Service
class CampaignLinkedToMobileAppService : RelationshipService<CampaignLinkedToMobileApp, Long, Long> {
    override fun getChildEntityIdsByParentIds(
        clientId: ClientId,
        operatorId: Long,
        parentIds: Set<Long>
    ): Set<Long> {
        // Наследники RelationshipService сейчас используются исключительно при копировании. И если вдруг при
        // копировании мы решили получить все кампании, прилинкованные к мобильному приложению, значит вместо
        // копирования оригинальной кампании, мы вызовем каскадное копирование всех кампаний, с тем же мобильным
        // приложением. И лучше упасть по принципу fail-fast, чем делать вид, что ничего страшного не произошло.
        TODO("Unable to copy all mobile app campaigns!")
    }
}
