package ru.yandex.direct.core.entity.mobileapp.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.grut.api.UpdatedObject
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.grut.objects.proto.CampaignV2.TCampaignV2Spec
import ru.yandex.grut.objects.proto.CampaignV2.TCampaignV2Spec.TSkAdNetwork
import ru.yandex.grut.objects.proto.client.Schema
import ru.yandex.grut.objects.proto.client.Schema.TCampaignV2

data class BundleWithSlot(
    val bundleId: String,
    val slot: Int,
)

@Service
class GrutSkadNetworkSlotService(
    private val grutApiService: GrutApiService
) {
    fun setSlotForCampaign(campaignId: Long, bundleId: String, slot: Int) {
        val grutCampaignToUpdate =
            TCampaignV2.newBuilder().apply {
                meta = Schema.TCampaignV2Meta.newBuilder().setDirectId(campaignId).build()
                spec = TCampaignV2Spec.newBuilder().setSkadNetwork(getGrutSkadNetworkInfo(bundleId, slot)).build()
            }

        val updatedObject = UpdatedObject(
            meta = grutCampaignToUpdate.meta.toByteString(),
            spec = grutCampaignToUpdate.spec.toByteString(),
            setPaths = listOf("/spec/skad_network")
        )

        grutApiService.campaignGrutDao.updateCampaigns(listOf(updatedObject))
    }

    fun freeSlotForCampaigns(campaignIds: Collection<Long>) {
        val grutCampaignsToUpdate = campaignIds
            .map {
                TCampaignV2.newBuilder().apply {
                    meta = Schema.TCampaignV2Meta.newBuilder().setDirectId(it).build()
                    spec = TCampaignV2Spec.newBuilder().build()
                }
            }.map {
                UpdatedObject(
                    meta = it.meta.toByteString(),
                    spec = it.spec.toByteString(),
                    setPaths = listOf(),
                    removePaths = listOf("/spec/skad_network/slot")
                )
            }
        grutApiService.campaignGrutDao.updateCampaigns(grutCampaignsToUpdate)
    }

    private fun getGrutSkadNetworkInfo(bundleId: String, slot: Int) =
        TSkAdNetwork.newBuilder().apply {
            this.bundleId = bundleId
            this.slot = slot
        }.build()
}
