package ru.yandex.direct.core.entity.mobileapp.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.noAccessToChangeDomain;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

/**
 * Валидатор добавления приложения
 */
@Component
@ParametersAreNonnullByDefault
public class MobileAppAddValidationService {
    private final MobileAppValidationService mobileAppValidationService;

    public MobileAppAddValidationService(MobileAppValidationService mobileAppValidationService) {
        this.mobileAppValidationService = mobileAppValidationService;
    }

    ValidationResult<MobileApp, Defect> validateMobileApp(@Nullable User operator, MobileApp mobileApp, ClientId clientId) {
        ModelItemValidationBuilder<MobileApp> vb = ModelItemValidationBuilder.of(mobileApp);

        if (operator != null) {
            // Добавлять приложение с доменом можно только операторам с внутренними ролями
            vb.item(MobileApp.DOMAIN)
                    .check(isNull(), noAccessToChangeDomain(), When.isTrue(!operator.getRole().isInternal()));
        }

        vb.checkBy(app -> mobileAppValidationService.validateMobileApp(app, clientId), When.isValid());
        return vb.getResult();
    }
}
