package ru.yandex.direct.core.entity.mobileapp.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.mobileapp.model.MobileGoalConversions
import ru.yandex.direct.core.entity.mobileapp.repository.MobileAppConversionStatisticRepository
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent
import ru.yandex.direct.core.entity.mobilecontent.model.OsType
import ru.yandex.direct.dbutil.model.ClientId


@Service
open class MobileAppConversionStatisticService(
    private val mobileAppConversionStatisticRepository: MobileAppConversionStatisticRepository,
    private val mobileAppService: MobileAppService,
) {

    fun getMobileGoalConversions(
        clientId: ClientId, mobileAppId: Long, goalIds: List<Long>, daysNum: Int
    ): List<MobileGoalConversions> {
        if (goalIds.isEmpty() or (daysNum < 1)) {
            return listOf()
        }
        val maybeMobileApp = mobileAppService.getMobileApp(clientId, mobileAppId)
        if (maybeMobileApp.isEmpty) {
            return listOf()
        }
        val mobileContent = maybeMobileApp.get().mobileContent

        // возвращаем отсутствие данных для неизвестных платформ и неопределённых приложений
        val platform = mobileContent.getBsPlatform() ?: return listOf()
        val appId = mobileContent.getBsAppId() ?: return listOf()

        return mobileAppConversionStatisticRepository.getConversionStats(
            appId, platform, goalIds, daysNum)
    }
}


private fun MobileContent.getBsAppId(): String? = when (osType) {
    OsType.ANDROID -> storeContentId
    OsType.IOS -> bundleId
    else -> null
}

private fun MobileContent.getBsPlatform(): String? = when (osType) {
    OsType.ANDROID -> "android"
    OsType.IOS -> "ios"
    else -> null
}
