package ru.yandex.direct.core.entity.mobileapp.service;

import java.util.List;

import javax.annotation.Nullable;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.domain.service.DomainService;
import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.mobileapp.repository.MobileAppRepository;
import ru.yandex.direct.core.entity.mobilegoals.MobileAppGoalsService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

/**
 * Создатель операций обновления мобильных приложений
 */
@Component
public class MobileAppUpdateOperationFactory {
    private final ShardHelper shardHelper;
    private final DslContextProvider dslContextProvider;
    private final DomainService domainService;
    private final MobileAppRepository mobileAppRepository;
    private final MobileAppUpdateValidationService mobileAppUpdateValidationService;
    private final MobileAppGoalsService mobileAppGoalsService;

    public MobileAppUpdateOperationFactory(ShardHelper shardHelper,
                                           DslContextProvider dslContextProvider,
                                           DomainService domainService,
                                           MobileAppRepository mobileAppRepository,
                                           MobileAppUpdateValidationService mobileAppUpdateValidationService,
                                           MobileAppGoalsService mobileAppGoalsService) {
        this.shardHelper = shardHelper;
        this.dslContextProvider = dslContextProvider;
        this.domainService = domainService;
        this.mobileAppRepository = mobileAppRepository;
        this.mobileAppUpdateValidationService = mobileAppUpdateValidationService;
        this.mobileAppGoalsService = mobileAppGoalsService;
    }

    public MobileAppUpdateOperation createPartialOperation(@Nullable User operator, ClientId clientId,
                                                           List<ModelChanges<MobileApp>> changes) {
        return createOperation(Applicability.PARTIAL, operator, clientId, changes);
    }

    public MobileAppUpdateOperation createFullOperation(@Nullable User operator,
                                                        ClientId clientId, List<ModelChanges<MobileApp>> changes) {
        return createOperation(Applicability.FULL, operator, clientId, changes);
    }

    public MobileAppUpdateOperation createOperation(
            Applicability applicability, @Nullable User operator, ClientId clientId,
            List<ModelChanges<MobileApp>> changes) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new MobileAppUpdateOperation(applicability, dslContextProvider, domainService,
                mobileAppRepository, mobileAppUpdateValidationService,
                operator, shard, clientId, changes,
                mobileAppGoalsService);
    }

}
