package ru.yandex.direct.core.entity.mobileapp.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.noAccessToChangeDomain;
import static ru.yandex.direct.validation.result.PathHelper.field;

@Component
@ParametersAreNonnullByDefault
public class MobileAppUpdateValidationService {
    private final MobileAppValidationService mobileAppValidationService;

    public MobileAppUpdateValidationService(MobileAppValidationService mobileAppValidationService) {
        this.mobileAppValidationService = mobileAppValidationService;
    }

    public ValidationResult<ModelChanges<MobileApp>, Defect> validateModelChanges(@Nullable User operator,
                                                                                  ModelChanges<MobileApp> modelChanges) {
        ValidationResult<ModelChanges<MobileApp>, Defect> vr = ValidationResult.success(modelChanges);
        if (modelChanges.isPropChanged(MobileApp.DOMAIN) && operator != null && !operator.getRole().isInternal()) {
            vr.getOrCreateSubValidationResult(
                    field(MobileApp.DOMAIN.name()), modelChanges.getChangedProp(MobileApp.DOMAIN))
                    .addError(noAccessToChangeDomain());
        }
        return vr;
    }

    public ValidationResult<MobileApp, Defect> validateMobileApp(MobileApp mobileApp, ClientId clientId) {
        return mobileAppValidationService.validateMobileApp(mobileApp, clientId);
    }
}
