package ru.yandex.direct.core.entity.mobileapp.util;

import ru.yandex.direct.core.entity.mobileapp.model.AppmetrikaUniqueKey;
import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppStoreType;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

public class MobileAppUtil {
    private MobileAppUtil() {
    }

    public static AppmetrikaUniqueKey getAppmetrikaUniqueKey(MobileApp mobileApp) {
        String bundleId = null;
        MobileAppStoreType storeType = null;
        MobileContent mobileContent = mobileApp.getMobileContent();

        if (mobileContent != null) {
            if (mobileContent.getOsType() == OsType.IOS) {
                bundleId = mobileContent.getBundleId();
            } else {
                bundleId = mobileContent.getStoreContentId();
            }
            storeType = mobileApp.getStoreType();
        }

        return new AppmetrikaUniqueKey()
                .withAppMetrikaApplicationId(mobileApp.getAppMetrikaApplicationId())
                .withBundleId(bundleId)
                .withStoreType(storeType);
    }
}
