package ru.yandex.direct.core.entity.mobilecontent.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;

/**
 * Используется для получения информации о приложениях клиента, объединяя данные из таблиц
 * mobile_content, adgroups_mobile_content, banners
 * см https://st.yandex-team.ru/DIRECT-80770
 */
@ParametersAreNonnullByDefault
public class MobileContentWithExtraData {
    final private MobileContent mobileContent;
    final private String storeHref;
    @Nullable
    final private String trackingUrl;

    public MobileContentWithExtraData(MobileContent mobileContent, String storeHref, @Nullable String trackingUrl) {
        this.mobileContent = mobileContent;
        this.storeHref = storeHref;
        this.trackingUrl = trackingUrl;
    }

    public MobileContent getMobileContent() {
        return mobileContent;
    }

    public String getStoreHref() {
        return storeHref;
    }

    @Nullable
    public String getTrackingUrl() {
        return trackingUrl;
    }
}
