package ru.yandex.direct.core.entity.mobilecontent.model;

/**
 * Доступные размеры аватарок мобильного контента
 * <p>
 * ВАЖНО: значения продублированы в перл-директе в %MobileContent::AVATARS_SIZES
 * при внесении изменения здесь, нужно поправить значение и там
 */
public enum MobileContentAvatarSize {
    ICON_S("icon-s", 16, 16),
    ICON_S_RETINA("icon-s-retina", 32, 32),
    ICON("icon", 65, 65),
    ICON_L("icon-l", 72, 72),
    ICON_LD("icon-ld", 80, 80),
    ICON_LDD("icon-ldd", 90, 90),
    ICON_XL("icon-xl", 144, 144),
    ICON_XLD("icon-xld", 150, 150),
    ICON_LD_RETINA("icon-ld-retina", 160, 160),
    ICON_LDD_RETINA("icon-ldd-retina", 180, 180),
    ICON_XLD_RETINA("icon-xld-retina", 300, 300),
    ORIG("orig", 0, 0),
    ;

    private int width;
    private int height;
    private String name;

    MobileContentAvatarSize(String name, int width, int height) {
        this.width = width;
        this.height = height;
        this.name = name;
    }

    /**
     * Вернуть истину, если для алиаса заданы ненулевые размеры
     */
    public boolean hasDimensions() {
        return width > 0 && height > 0;
    }

    public String getName() {
        return name;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }
}
