package ru.yandex.direct.core.entity.mobilecontent.repository;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.mobilecontent.model.AvailableAction;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContentExternalWorldMoney;
import ru.yandex.direct.core.entity.mobilecontent.model.StoreActionForPrices;
import ru.yandex.direct.core.entity.mobilecontent.model.StoreCountry;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentStatusbssynced;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.misc.dataSize.DataSize;

import static java.util.stream.Collectors.joining;

public class MobileContentMapping {
    private MobileContentMapping() {
    }

    static MobileContentStatusbssynced statusBsSyncedToDbFormat(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? MobileContentStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    static StatusBsSynced statusBsSyncedFromDbFormat(MobileContentStatusbssynced bidsStatusbssynced) {
        return bidsStatusbssynced != null ? StatusBsSynced.valueOfDbFormat(bidsStatusbssynced.toString()) : null;
    }

    static String storeCountryToDbFormat(StoreCountry storeCountry) {
        return storeCountry != null ? storeCountry.toString() : null;
    }

    static StoreCountry storeCountryFromDbFormat(String s) {
        return s != null ? StoreCountry.valueOf(s) : null;
    }

    static Long appSizeBytesToDbFormat(DataSize dataSize) {
        return dataSize != null ? dataSize.toBytes() : null;
    }

    static DataSize appSizeBytesFromDbFormat(Long l) {
        return l != null ? DataSize.fromBytes(l) : null;
    }

    /**
     * Поле в базе nullable, пустые строки не пишем.
     */
    static String availableActionToDbFormat(Set<AvailableAction> availableActions) {
        return availableActions == null ? null : availableActions.stream().map(Enum::toString).collect(joining(","));
    }

    /**
     * Временно проглатываем пустые строки, записанные ранее.
     * TODO DIRECT-79493 заменить StringUtils::isBlank на `s == null`
     */
    static Set<AvailableAction> availableActionFromDbFormat(String s) {
        return StringUtils.isBlank(s) ? Collections.emptySet()
                : Arrays.stream(s.split("\\s*,\\s*"))
                .map(AvailableAction::valueOf)
                .collect(Collectors.toSet());
    }

    static String pricesToDbFormat(
            Map<String, Map<StoreActionForPrices, MobileContentExternalWorldMoney>> prices) {
        if (prices == null) {
            return "{}";
        }

        try {
            return JsonUtils.MAPPER.writeValueAsString(prices);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    public static Map<String, Map<StoreActionForPrices, MobileContentExternalWorldMoney>> pricesFromDbFormat(
            String pricesJson) {
        if (pricesJson == null) {
            return new HashMap<>();
        }

        TypeFactory tf = JsonUtils.getTypeFactory();
        MapLikeType mlt = tf.constructMapLikeType(
                Map.class,
                tf.constructType(String.class),
                tf.constructMapType(
                        Map.class,
                        StoreActionForPrices.class,
                        MobileContentExternalWorldMoney.class
                )
        );
        try {
            return JsonUtils.MAPPER.readValue(pricesJson, mlt);
        } catch (IOException e) {
            throw new IllegalArgumentException("can not parse json", e);
        }
    }

    static String screensToDbFormat(List<Map<String, String>> data) {
        if (data == null) {
            return "[]";
        }

        try {
            return JsonUtils.MAPPER.writeValueAsString(data);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    public static List<Map<String, String>> screensFromDbFormat(String dataJson) {
        if (dataJson == null) {
            return List.of();
        }

        TypeFactory tf = JsonUtils.getTypeFactory();
        var mlt = tf.constructCollectionLikeType(
                List.class,
                tf.constructMapType(
                        Map.class,
                        String.class,
                        String.class
                )
        );
        try {
            return JsonUtils.MAPPER.readValue(dataJson, mlt);
        } catch (IOException e) {
            throw new IllegalArgumentException("can not parse json", e);
        }
    }
}
