package ru.yandex.direct.core.entity.mobilecontent.service;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.mobilecontent.model.AgeLabel;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.core.entity.mobilecontent.model.StoreCountry;

public class MobileContentServiceConstants {
    /*
        ВАЖНО: хеш продублирован в перл-директе в $MobileContent::os_type2avatars_instance
        при внесении изменения здесь, нужно поправить значение и там
         */
    static final Map<OsType, String> OS_TYPE_TO_AVATARS_INSTANCE = ImmutableMap.<OsType, String>builder()
            .put(OsType.IOS, "itunes-icon")
            .put(OsType.ANDROID, "google-play-app-icon")
            .build();
    /*
        ВАЖНО: хеш продублирован в перл-директе в $MobileContent::os_type_2_store_name
        при внесении изменения здесь, нужно поправить значение и там
         */
    public static final Map<OsType, String> OS_TYPE_TO_STORE_NAME = ImmutableMap.<OsType, String>builder()
            .put(OsType.IOS, "App Store")
            .put(OsType.ANDROID, "Google Play")
            .build();

    public static final Map<OsType, String> OS_TYPE_TO_YT_PATH = ImmutableMap.<OsType, String>builder()
            .put(OsType.IOS, "itunes")
            .put(OsType.ANDROID, "gplay")
            .build();

    /*
        ВАЖНО: хеш продублирован в перл-директе в $MobileContent::map_age_lables
        при внесении изменения здесь, нужно поправить значение и там
         */
    public static final Map<OsType, Map<StoreCountry, Map<String, AgeLabel>>> YT_AGE_LABELS = ImmutableMap.of(
            OsType.ANDROID, ImmutableMap.<StoreCountry, Map<String, AgeLabel>>builder()
                    .put(StoreCountry.US, ImmutableMap.of(
                            "Everyone", AgeLabel._6_2B,
                            "Everyone 10+", AgeLabel._12_2B,
                            "Teen", AgeLabel._16_2B,
                            "Mature 17+", AgeLabel._18_2B))
                    .put(StoreCountry.TR, ImmutableMap.of(
                            "PEGI 3", AgeLabel._6_2B,
                            "PEGI 7", AgeLabel._12_2B,
                            "PEGI 12", AgeLabel._12_2B,
                            "PEGI 16", AgeLabel._16_2B,
                            "PEGI 18", AgeLabel._18_2B))
                    .put(StoreCountry.RU, ImmutableMap.of(
                            "3+", AgeLabel._6_2B,
                            "7+", AgeLabel._12_2B,
                            "12+", AgeLabel._12_2B,
                            "16+", AgeLabel._16_2B,
                            "18+", AgeLabel._18_2B))
                    .put(StoreCountry.UA, ImmutableMap.<String, AgeLabel>builder()
                            .put("3+", AgeLabel._6_2B)
                            .put("7+", AgeLabel._12_2B)
                            .put("12+", AgeLabel._12_2B)
                            .put("16+", AgeLabel._16_2B)
                            .put("18+", AgeLabel._18_2B)
                            .put("Від 3 років", AgeLabel._6_2B)
                            .put("Від 7 років", AgeLabel._12_2B)
                            .put("Від 12 років", AgeLabel._12_2B)
                            .put("Від 16 років", AgeLabel._16_2B)
                            .put("Від 18 років", AgeLabel._18_2B)
                            .build())
                    .put(StoreCountry.BY, ImmutableMap.<String, AgeLabel>builder()
                            .put("3+", AgeLabel._6_2B)
                            .put("7+", AgeLabel._12_2B)
                            .put("12+", AgeLabel._12_2B)
                            .put("16+", AgeLabel._16_2B)
                            .put("18+", AgeLabel._18_2B)
                            .put("Рэйтынг: 3+", AgeLabel._6_2B)
                            .put("Рэйтынг: 7+", AgeLabel._12_2B)
                            .put("Рэйтынг: 12+", AgeLabel._12_2B)
                            .put("Рэйтынг: 16+", AgeLabel._16_2B)
                            .put("Рэйтынг: 18+", AgeLabel._18_2B)
                            .build())
                    .put(StoreCountry.KZ, ImmutableMap.of(
                            "3+", AgeLabel._6_2B,
                            "7+", AgeLabel._12_2B,
                            "12+", AgeLabel._12_2B,
                            "16+", AgeLabel._16_2B,
                            "18+", AgeLabel._18_2B))
                    .build(),

            OsType.IOS, ImmutableMap.copyOf(StreamEx.of(StoreCountry.values())
                    .mapToEntry(country -> ImmutableMap.of(
                            "4+", AgeLabel._6_2B,
                            "9+", AgeLabel._12_2B,
                            "12+", AgeLabel._12_2B,
                            "17+", AgeLabel._18_2B))
                    .toMap()));

    public static final Map<String, String> FIXED_DOMAINS = ImmutableMap.<String, String>builder()
            .put("app.mobile.lonelydonkey", "lovelama.ru")
            .put("by.alfabank.insync", "www.alfabank.by")
            .put("com.allgoritm.youla", "youla.ru")
            .put("com.boloid.dominos", "dominospizza.ru")
            .put("com.citymobil", "city-mobil.ru")
            .put("com.company.robinson", "pricebox.mobi")
            .put("com.deliveryclub", "www.delivery-club.ru")
            .put("com.dipan.feelingtouch.godfather", "feelingtouch.com")
            .put("com.droidhang.ad", "www.droidhang.com")
            .put("com.ea.gp.fifamobile", "www.easports.com")
            .put("com.farfetch.farfetchshop", "farfetch.com")
            .put("com.fingersoft.hcr2", "fingersoft.net")
            .put("com.fudstor.app", "fudstor.ru")
            .put("com.gettaxi.android", "www.gett.com")
            .put("com.iconjob.android", "radarapp.ru")
            .put("com.its.rto", "rutaxi.ru")
            .put("com.joom", "joom.com")
            .put("com.megalabs.megafon.tv", "megafon.tv")
            .put("com.onetwotrip.onetwotrip", "www.onetwotrip.com")
            .put("com.plarium.vikings", "plarium.com")
            .put("com.rsg.kor", "wotblitz.com")
            .put("com.taxsee.taxsee", "taximaxim.com")
            .put("com.UCMobile.intl", "www.ucweb.com")
            .put("com.ufs.mticketing", "www.ufs-online.ru")
            .put("com.vsemayki.app", "www.vsemayki.ru")
            .put("com.wheely.wheely", "wheely.com")
            .put("com.wokkalokka", "wokkalokka.com")
            .put("com.yandex.mobile.realty", "realty.yandex.ru")
            .put("com.yandex.toloka.androidapp", "toloka.yandex.ru")
            .put("id1061992624", "zvukislov.ru")
            .put("id1123086411", "pricebox.mobi")
            .put("id1136621457", "velostrana.ru")
            .put("id1200434407", "avtocod.ru")
            .put("id1269023171", "auto.rent")
            .put("id1272640583", "pandao.ru")
            .put("id1278873854", "sushi-ryba.ru")
            .put("id1296791829", "tutu.ru")
            .put("id379968583", "www.busuu.com")
            .put("id468731698", "money.yandex.ru")
            .put("id472650686", "taxi.yandex.ru")
            .put("id506360097", "rutaxi.ru")
            .put("id555970430", "alfabank.ru")
            .put("id579220388", "city-mobil.ru")
            .put("id894649641", "dodopizza.ru")
            .put("id959592459", "ozon.travel")
            .put("info.goodline.communals", "jkh.prostoplat.su")
            .put("info.goodline.mobile", "goodline.info")
            .put("kz.slando", "olx.kz")
            .put("net.wargaming.wot.blitz", "wotblitz.com")
            .put("ru.alfabank.mobile.android", "alfabank.ru")
            .put("ru.alfabank.oavdo.amc", "alfabank.ru")
            .put("ru.auto.ara", "auto.ru")
            .put("ru.avtocod", "avtocod.ru")
            .put("ru.avtoraport", "avtoraport.ru")
            .put("ru.belkacar.belkacar", "belkacar.ru")
            .put("ru.city-mobil.taxi", "city-mobil.ru")
            .put("ru.dodopizza.app", "dodopizza.ru")
            .put("ru.dostaevsky.android", "dostaevsky.ru")
            .put("ru.dvaberega", "2-berega.ru")
            .put("ru.farpost.dromfilter", "drom.ru")
            .put("ru.foodfox.client", "eda.yandex.ru")
            .put("ru.ftc.fee", "koronapay.com")
            .put("ru.gtcgroup.client.troikacars", "troikacars.ru")
            .put("ru.handh.android.zakazaka", "zakazaka.ru")
            .put("ru.infinity.taxi.client.nf", "taxi-nf.ru")
            .put("ru.join", "zarplata.ru")
            .put("ru.litres.android", "www.litres.ru")
            .put("ru.masani.client", "masani.ru")
            .put("ru.masani.driver", "masani.ru")
            .put("ru.mts.music.android", "music.mts.ru")
            .put("ru.mts.mymts", "music.mts.ru")
            .put("ru.profi.client", "profi.ru")
            .put("ru.shiptor.shiptor", "shiptor.ru")
            .put("ru.taximaster.tmtaxicaller.id0217", "www.rus3.com")
            .put("ru.travelata.app", "travelata.ru")
            .put("ru.yandex.med", "health.yandex.ru")
            .put("ru.yandex.money", "money.yandex.ru")
            .put("ru.yandex.music", "music.yandex.ru")
            .put("ru.yandex.taxi", "taxi.yandex.ru")
            .put("ru.yandex.yandexmaps", "maps.yandex.ru")
            .put("ru.yandex.yandexnavi", "navigator.yandex.ru")
            .put("store.panda.client", "pandao.ru")
            .put("travel.ozon.mobile", "ozon.travel")
            .build();
}
