package ru.yandex.direct.core.entity.mobilecontent.util;

import java.math.BigDecimal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.mobilecontent.model.MobileContentExternalWorldMoney;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;

import static ru.yandex.direct.currency.Money.MONEY_MATH_CONTEXT;

@ParametersAreNonnullByDefault
public class MobileContentUtil {
    private MobileContentUtil() {
    }

    /**
     * Получить значение {@link ru.yandex.direct.currency.Money} из
     * {@link ru.yandex.direct.core.entity.mobilecontent.model.MobileContentExternalWorldMoney} или вернуть null,
     * если его невозможно построить
     */
    @Nullable
    public static Money getMoneyValue(MobileContentExternalWorldMoney externalWorldMoney) {
        CurrencyCode code;
        try {
            code = CurrencyCode.valueOf(externalWorldMoney.getCurrency());
        } catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
        return Money.valueOf(externalWorldMoney.getSum(), code);
    }

    public static MobileContentExternalWorldMoney getExternalWorldMoney(Money money) {
        return new MobileContentExternalWorldMoney()
                .withSum(money.bigDecimalValue())
                .withCurrency(money.getCurrencyCode().toString());
    }

    public static MobileContentExternalWorldMoney getExternalWorldMoney(String sum, String currencyCode) {
        return new MobileContentExternalWorldMoney()
                .withSum(new BigDecimal(sum, MONEY_MATH_CONTEXT))
                .withCurrency(currencyCode);
    }

    public static MobileContentExternalWorldMoney getExternalWorldMoney(String sum, CurrencyCode currencyCode) {
        return getExternalWorldMoney(sum, currencyCode.toString());
    }
}
