package ru.yandex.direct.core.entity.mobilegoals.model;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.mobileapp.model.AppmetrikaEventSubtype;
import ru.yandex.direct.core.entity.mobileapp.model.AppmetrikaEventType;

public enum AppmetrikaInternalEvent {
    START(AppmetrikaEventType.START, AppmetrikaEventSubtype.OTHER),
    REVENUE(AppmetrikaEventType.REVENUE, AppmetrikaEventSubtype.OTHER),
    ECOMMERCE_SHOW_SCREEN(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.SHOW_SCREEN),
    ECOMMERCE_SHOW_PRODUCT_CARD(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.SHOW_PRODUCT_CARD),
    ECOMMERCE_SHOW_PRODUCT_DETAILS(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.SHOW_PRODUCT_DETAILS),
    ECOMMERCE_ADD_TO_CART(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.ADD_TO_CART),
    ECOMMERCE_REMOVE_FROM_CART(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.REMOVE_FROM_CART),
    ECOMMERCE_BEGIN_CHECKOUT(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.BEGIN_CHECKOUT),
    ECOMMERCE_PURCHASE(AppmetrikaEventType.ECOMMERCE, AppmetrikaEventSubtype.PURCHASE);

    private static final Logger logger = LoggerFactory.getLogger(AppmetrikaInternalEvent.class);
    private final AppmetrikaEventType appmetrikaEventType;
    private final AppmetrikaEventSubtype appmetrikaEventSubtype;

    AppmetrikaInternalEvent(AppmetrikaEventType appmetrikaEventType, AppmetrikaEventSubtype appmetrikaEventSubtype) {
        this.appmetrikaEventType = appmetrikaEventType;
        this.appmetrikaEventSubtype = appmetrikaEventSubtype;
    }

    public AppmetrikaEventType getType() {
        return appmetrikaEventType;
    }

    public AppmetrikaEventSubtype getSubtype() {
        return appmetrikaEventSubtype;
    }

    /**
     * Конвертирует AppmetrikaInternalEvent из типа и подтипа
     * strict = true требуется при работе с базой
     * strict = false нужно при получении данных от аппметрики, чтобы не падало при добавлении новых значений
     */
    public static AppmetrikaInternalEvent fromTypeAndSubtype(AppmetrikaEventType type, AppmetrikaEventSubtype subtype,
                                                             boolean strict) {
        for (AppmetrikaInternalEvent e : AppmetrikaInternalEvent.values()) {
            if (Objects.equals(e.getType(), type) && Objects.equals(e.getSubtype(), subtype)) {
                return e;
            }
        }
        if (!strict) {
            logger.debug("Unknown value type: " + type + ", subtype: " + subtype);
            return null;
        }
        throw new IllegalArgumentException("Unknown value type: " + type + ", subtype: " + subtype);
    }
}
