package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;

/**
 * Общие параметры, которые присылает модерация в вердиктах
 */
@ParametersAreNonnullByDefault
public abstract class AbstractModerationResponse<T extends ModerationMeta> {

    // сервис, который прислал запрос. Обычно равен direct
    private ModerationServiceNames service;

    //тип заявки, которая обрабатывалась
    private ModerationObjectType type;

    private long unixtime;

    private T meta;

    private Attributes attributes;

    // оригинальный json, который был получен из модерации
    // чтобы удобно было перекладывать
    private String originalJson;

    @JsonProperty("service")
    public ModerationServiceNames getService() {
        return service;
    }

    public void setService(ModerationServiceNames service) {
        this.service = service;
    }

    @Nullable
    @JsonProperty("type")
    public ModerationObjectType getType() {
        return type;
    }

    public void setType(ModerationObjectType type) {
        this.type = type;
    }

    @JsonProperty("unixtime")
    public long getUnixtime() {
        return unixtime;
    }

    public void setUnixtime(long unixtime) {
        this.unixtime = unixtime;
    }

    public T getMeta() {
        return meta;
    }

    public void setMeta(T meta) {
        this.meta = meta;
    }

    @JsonProperty("attributes")
    public Attributes getAttributes() {
        return attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @JsonIgnore
    public String getOriginalJson() {
        return originalJson;
    }

    public void setOriginalJson(String originalJson) {
        this.originalJson = originalJson;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbstractModerationResponse<?> response = (AbstractModerationResponse<?>) o;
        return unixtime == response.unixtime &&
                Objects.equals(service, response.service) &&
                Objects.equals(type, response.type) &&
                Objects.equals(meta, response.meta) &&
                Objects.equals(attributes, response.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service.getValue(), type, unixtime, meta, attributes);
    }

    @Override
    public String toString() {
        return "AbstractModerationResponse{" +
                "service='" + service + '\'' +
                ", type='" + type + '\'' +
                ", unixtime=" + unixtime +
                ", meta=" + meta +
                ", attributes=" + attributes +
                '}';
    }
}
