package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class BannerLink {
    /**
     * Может быть null
     */
    private String href;

    /**
     * Может быть null
     */
    private String parametrizedHref;

    /**
     * Может быть null
     */
    private String mobileHref;

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public BannerLink setHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("parametrized_href")
    public String getParametrizedHref() {
        return parametrizedHref;
    }

    public BannerLink setParametrizedHref(String parametrizedHref) {
        this.parametrizedHref = parametrizedHref;
        return this;
    }

    @JsonProperty("mobile_href")
    public String getMobileHref() {
        return mobileHref;
    }

    public BannerLink setMobileHref(String mobileHref) {
        this.mobileHref = mobileHref;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BannerLink that = (BannerLink) o;
        return Objects.equals(href, that.href) &&
                Objects.equals(mobileHref, that.mobileHref);
    }

    @Override
    public int hashCode() {
        return Objects.hash(href, mobileHref);
    }
}
