package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class BannerModerationMeta extends BaseBannerModerationMeta {

    private Long bsBannerId;

    @JsonProperty("bs_banner_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Long getBsBannerId() {
        return bsBannerId;
    }

    public BannerModerationMeta setBsBannerId(Long bsBannerId) {
        this.bsBannerId = bsBannerId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerModerationMeta that = (BannerModerationMeta) o;
        return Objects.equals(bsBannerId, that.bsBannerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), bsBannerId);
    }

    @Override
    public String toString() {
        return "BannerModerationMeta{" +
                "bsBannerId=" + bsBannerId +
                '}' + super.toString();
    }
}
