package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Вердикт модерации на баннер.
 * type определяет тип баннера
 */
@ParametersAreNonnullByDefault
public class BannerModerationResponse extends AbstractModerationResultResponse<BannerModerationMeta, Verdict> {

    private Verdict result;

    @JsonProperty("meta")
    @Override
    public BannerModerationMeta getMeta() {
        return super.getMeta();
    }

    @Override
    @JsonProperty("result")
    public Verdict getResult() {
        return result;
    }

    public void setResult(Verdict result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerModerationResponse that = (BannerModerationResponse) o;
        return Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), result);
    }

    @Override
    public String toString() {
        return "BannerModerationResponse{" +
                "super='" + super.toString() + '\'' +
                ", result=" + result +
                '}';
    }
}
