package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

@ParametersAreNonnullByDefault
public abstract class BaseBannerModerationMeta extends BaseModerationMeta implements AdGroupModerationMeta {

    private long campaignId;

    private long adGroupId;

    private long bannerId;

    private CampaignsType campaignType;

    private BannersBannerType bannerType;

    private PhrasesAdgroupType adgroupType;

    @JsonProperty("campaign_id")
    public long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(long campaignId) {
        this.campaignId = campaignId;
    }

    @JsonProperty("group_id")
    public long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(long adGroupId) {
        this.adGroupId = adGroupId;
    }

    @JsonProperty("banner_id")
    public long getBannerId() {
        return bannerId;
    }

    public void setBannerId(long bannerId) {
        this.bannerId = bannerId;
    }

    @JsonProperty("direct_campaign_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CampaignsType getCampaignType() {
        return campaignType;
    }

    public void setCampaignType(CampaignsType campaignType) {
        this.campaignType = campaignType;
    }

    @JsonProperty("direct_banner_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public BannersBannerType getBannerType() {
        return bannerType;
    }

    public void setBannerType(BannersBannerType bannerType) {
        this.bannerType = bannerType;
    }

    @JsonProperty("direct_adgroup_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhrasesAdgroupType getAdgroupType() {
        return adgroupType;
    }

    public void setAdgroupType(PhrasesAdgroupType adgroupType) {
        this.adgroupType = adgroupType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseBannerModerationMeta that = (BaseBannerModerationMeta) o;
        return campaignId == that.campaignId && adGroupId == that.adGroupId && bannerId == that.bannerId
                && campaignType == that.campaignType && bannerType == that.bannerType && adgroupType == that.adgroupType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, adGroupId, bannerId, campaignType, bannerType, adgroupType);
    }

    @Override
    public String toString() {
        return "BaseBannerModerationMeta{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", bannerId=" + bannerId +
                ", campaignType=" + campaignType+
                ", bannerType=" + bannerType+
                ", adgroupType=" + adgroupType+
                '}' + super.toString();
    }
}
