package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class BaseModerationMeta implements ModerationMeta {

    private long uid;

    private long clientId;

    private long versionId;

    @JsonProperty("user_id")
    public long getUid() {
        return uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    @JsonProperty("client_id")
    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value = "version_id", required = true)
    public long getVersionId() {
        return versionId;
    }

    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseModerationMeta that = (BaseModerationMeta) o;
        return uid == that.uid && clientId == that.clientId && versionId == that.versionId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, clientId, versionId);
    }

    @Override
    public String toString() {
        return "BaseModerationMeta{" +
                "uid=" + uid +
                ", clientId=" + clientId +
                ", versionId=" + versionId +
                '}';
    }
}
