package ru.yandex.direct.core.entity.moderation.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс характеризует объект, который посылает модерация в очередь ошибок
 */
@ParametersAreNonnullByDefault
public class ModerationError extends AbstractModerationResponse<BannerModerationMeta> {

    @JsonProperty("error")
    private String error;

    @JsonProperty("error_token")
    private ModerationErrorToken code;

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public ModerationErrorToken getCode() {
        return code;
    }

    public ModerationError setCode(ModerationErrorToken code) {
        this.code = code;
        return this;
    }

    @Override
    public String toString() {
        return "ModerationError{" +
                "error='" + error + '\'' +
                ", code=" + code +
                '}';
    }
}
