package ru.yandex.direct.core.entity.moderation.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Enums;

public enum ModerationErrorToken {
    BAD_META,
    BAD_DATA,
    MODERATION_NOT_NEEDED,
    NO_PARENT_OBJECT,
    UNKNOWN_ERROR;

    @JsonCreator
    public static ModerationErrorToken fromString(String key) {
        return key == null
                ? null
                : Enums.getIfPresent(ModerationErrorToken.class, key.toUpperCase()).or(UNKNOWN_ERROR);

    }
}
