package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;

@ParametersAreNonnullByDefault
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ModerationRequest<M extends ModerationMeta> {
    private ModerationServiceNames service;

    private ModerationObjectType type;

    private long unixtime;

    private M meta;

    private Attributes attributes;

    private ModerationWorkflow workflow;

    @JsonProperty("workflow")
    public ModerationWorkflow getWorkflow() {
        return workflow;
    }

    public ModerationRequest setWorkflow(ModerationWorkflow workflow) {
        this.workflow = workflow;
        return this;
    }

    @JsonProperty("service")
    public ModerationServiceNames getService() {
        return service;
    }

    public void setService(ModerationServiceNames service) {
        this.service = service;
    }

    @JsonProperty("type")
    public ModerationObjectType getType() {
        return type;
    }

    public void setType(ModerationObjectType type) {
        this.type = type;
    }

    @JsonProperty("unixtime")
    public long getUnixtime() {
        return unixtime;
    }

    public void setUnixtime(long unixtime) {
        this.unixtime = unixtime;
    }

    @JsonProperty("meta")
    public M getMeta() {
        return meta;
    }

    public void setMeta(M meta) {
        this.meta = meta;
    }

    @JsonProperty("attributes")
    public Attributes getAttributes() {
        return attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModerationRequest<?> that = (ModerationRequest<?>) o;
        return unixtime == that.unixtime &&
                Objects.equals(service, that.service) &&
                Objects.equals(type, that.type) &&
                Objects.equals(meta, that.meta) &&
                Objects.equals(attributes, that.attributes) &&
                Objects.equals(workflow, that.workflow);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service.getValue(), type, unixtime, meta, attributes, workflow);
    }

    @Override
    public String toString() {
        return "ModerationRequest{" +
                "service='" + service + '\'' +
                ", type='" + type + '\'' +
                ", unixtime=" + unixtime +
                ", meta=" + meta +
                ", attributes=" + attributes +
                ", workflow=" + workflow +
                '}';
    }
}
