package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ModerationRequestWithData<M extends ModerationMeta, D extends BaseModerationData> extends ModerationRequest<M> {

    private D data;

    @JsonProperty("data")
    public D getData() {
        return data;
    }

    public void setData(D data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModerationRequestWithData<?, ?> that = (ModerationRequestWithData<?, ?>) o;
        return Objects.equals(data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), data);
    }

    @Override
    public String toString() {
        return "ModerationRequestWithData{" +
                "data=" + data +
                '}';
    }


}
