package ru.yandex.direct.core.entity.moderation.model;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonDetailed;

public class ModerationResult {
    @JsonProperty("verdict")
    protected ModerationDecision verdict;

    @JsonProperty("reasons")
    protected List<Long> reasons;

    @JsonProperty("detailed_reasons")
    protected List<ModerationReasonDetailed> detailedReasons;

    public ModerationDecision getVerdict() {
        return verdict;
    }

    public void setVerdict(ModerationDecision verdict) {
        this.verdict = verdict;
    }

    public List<Long> getReasons() {
        return reasons;
    }

    public void setReasons(List<Long> reasons) {
        this.reasons = reasons;
    }

    public List<ModerationReasonDetailed> getDetailedReasons() {
        return detailedReasons;
    }

    public void setDetailedReasons(List<ModerationReasonDetailed> detailedReasons) {
        this.detailedReasons = detailedReasons;
    }

    /*
    Конвертирует список id причин в расширенный формат с информацией из detailedReasons
     */
    @Nullable
    public List<ModerationReasonDetailed> getReasonsWithDetails() {
        if (reasons == null) {
            return null;
        }
        final Map<Long, ModerationReasonDetailed> detailedReasonsMap;
        if (detailedReasons != null) {
            detailedReasonsMap = detailedReasons.stream()
                    .collect(Collectors.toMap(ModerationReasonDetailed::getId, Function.identity(), (l, r) -> l));
        } else {
            detailedReasonsMap = null;
        }
        return getReasons()
                .stream()
                .map(reasonId -> detailedReasonsMap != null && detailedReasonsMap.containsKey(reasonId) ?
                        detailedReasonsMap.get(reasonId) : new ModerationReasonDetailed().withId(reasonId))
                .collect(Collectors.toList());
    }
}
