package ru.yandex.direct.core.entity.moderation.model;

import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import one.util.streamex.StreamEx;

import static java.util.function.Function.identity;

public enum ModerationWorkflow {
    COMMON("common"),
    AUTO_ACCEPT("auto_accept"),
    MANUAL("manual_only"),
    USER_FLAGS("user_flags"),
    ;

    private static final Map<String, ModerationWorkflow> byName = StreamEx
            .of(ModerationWorkflow.values())
            .toMap(ModerationWorkflow::toString, identity());

    private final String name;

    ModerationWorkflow(String name) {
        this.name = name;
    }

    @Nullable
    @JsonCreator
    public static ModerationWorkflow parse(String text) {
        return text != null ? byName.get(text) : null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.name;
    }
}
