package ru.yandex.direct.core.entity.moderation.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class Verdict extends ModerationResult {
    private Map<String, String> flags;

    private List<Long> minusRegions;

    private String advertisedItem;

    private String dynDisclaimer;

    private List<Long> categories;

    private String lang;

    private List<Long> catalogiaIds;

    @JsonProperty("flags")
    public Map<String, String> getFlags() {
        return flags;
    }

    public void setFlags(Map<String, String> flags) {
        this.flags = flags;
    }

    @JsonProperty("minus_regions")
    public List<Long> getMinusRegions() {
        return minusRegions;
    }

    public void setMinusRegions(List<Long> minusRegions) {
        this.minusRegions = minusRegions;
    }

    @JsonProperty("advertised_item")
    public String getAdvertisedItem() {
        return advertisedItem;
    }

    public void setAdvertisedItem(String advertisedItem) {
        this.advertisedItem = advertisedItem;
    }

    @JsonProperty("categories")
    public List<Long> getCategories() {
        return categories;
    }

    public void setCategories(List<Long> categories) {
        this.categories = categories;
    }

    @JsonProperty("lang")
    public String getLang() {
        return lang;
    }

    public void setLang(@Nullable String lang) {
        this.lang = lang;
    }

    @JsonProperty("dyn_disclaimer")
    public String getDynDisclaimer() {
        return dynDisclaimer;
    }

    public void setDynDisclaimer(String dynDisclaimer) {
        this.dynDisclaimer = dynDisclaimer;
    }

    @JsonProperty("catalogia_ids")
    public List<Long> getCatalogiaIds() {
        return catalogiaIds;
    }

    public void setCatalogiaIds(List<Long> catalogiaIds) {
        this.catalogiaIds = catalogiaIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Verdict verdict1 = (Verdict) o;
        return Objects.equals(flags, verdict1.flags) &&
                Objects.equals(verdict, verdict1.verdict) &&
                Objects.equals(reasons, verdict1.reasons) &&
                Objects.equals(minusRegions, verdict1.minusRegions) &&
                Objects.equals(advertisedItem, verdict1.advertisedItem) &&
                Objects.equals(dynDisclaimer, verdict1.dynDisclaimer) &&
                Objects.equals(categories, verdict1.categories) &&
                Objects.equals(lang, verdict1.lang) &&
                Objects.equals(catalogiaIds, verdict1.catalogiaIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flags, verdict, reasons, minusRegions, advertisedItem, dynDisclaimer, categories, lang,
                catalogiaIds);
    }

    @Override
    public String toString() {
        return "Verdict{" +
                "flags=" + flags +
                ", verdict='" + verdict + '\'' +
                ", reasons=" + reasons +
                ", minusRegions=" + minusRegions +
                ", advertisedItem='" + advertisedItem + '\'' +
                ", dynDisclaimer='" + dynDisclaimer + '\'' +
                ", categories=" + categories +
                ", lang='" + lang + '\'' +
                ", catalogiaIds=" + catalogiaIds +
                '}';
    }
}
