package ru.yandex.direct.core.entity.moderation.model.adgroup;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AdGroupModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.BaseModerationMeta;

public class AdGroupModerationMetaImpl extends BaseModerationMeta implements AdGroupModerationMeta {

    private long campaignId;

    private long adGroupId;

    @JsonProperty("campaign_id")
    public long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(long campaignId) {
        this.campaignId = campaignId;
    }

    @JsonProperty("group_id")
    public long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(long adGroupId) {
        this.adGroupId = adGroupId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdGroupModerationMetaImpl that = (AdGroupModerationMetaImpl) o;
        return campaignId == that.campaignId && adGroupId == that.adGroupId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignId, adGroupId);
    }

    @Override
    public String toString() {
        return "AdGroupModerationMetaImpl{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                '}';
    }
}
