package ru.yandex.direct.core.entity.moderation.model.asset;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BannerButtonRequestData extends BaseModerationData {

    private String href;

    private String buttonText;

    @JsonProperty("button_text")
    public String getButtonText() {
        return buttonText;
    }

    public BannerButtonRequestData setButtonText(@Nullable String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public BannerButtonRequestData setHref(String href) {
        this.href = href;
        return this;
    }
}
