package ru.yandex.direct.core.entity.moderation.model.asset;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BannerLogoRequestData extends BaseModerationData {

    private String host;
    private String imageHash;
    private Integer mdsGroupId;
    private String namespace;

    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    public BannerLogoRequestData setHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty("image_hash")
    public String getImageHash() {
        return imageHash;
    }

    public BannerLogoRequestData setImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    @JsonProperty("mds_group_id")
    public Integer getMdsGroupId() {
        return mdsGroupId;
    }

    public BannerLogoRequestData setMdsGroupId(Integer mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    public BannerLogoRequestData setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

}
