package ru.yandex.direct.core.entity.moderation.model.asset

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationRequest
import ru.yandex.direct.core.entity.moderation.model.BaseModerationData
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType


@JsonInclude(JsonInclude.Include.NON_NULL)
class MulticardModerationImage(
    @JsonProperty("host")
    val host: String,
    @JsonProperty("image_hash")
    val imageHash: String,
    @JsonProperty("namespace")
    val namespace: String,
    @JsonProperty("mds_group_id")
    val mdsGroupId: Int,
)

@JsonInclude(JsonInclude.Include.NON_NULL)
class MulticardModerationDataItem(
    @JsonProperty("id")
    val id: Long,
    @JsonProperty("order")
    val order: Long,
    @JsonProperty("image")
    val image: MulticardModerationImage,
    @JsonProperty("text")
    val text: String?,
    @JsonProperty("href")
    val href: String?,
)

enum class MulticardModerationBannerType(val bannerType: BannersBannerType) {
    @JsonProperty("text")
    TEXT(BannersBannerType.text),
    @JsonProperty("cpm_video")
    CPM_VIDEO(BannersBannerType.cpm_banner),
    ;

    companion object {
        private val byBannerType: Map<BannersBannerType, MulticardModerationBannerType> =
            values().associateBy { it.bannerType }

        fun fromBannerType(bannerType: BannersBannerType): MulticardModerationBannerType = byBannerType[bannerType]
            ?: throw IllegalArgumentException("Invalid multicard banner type: $bannerType")
    }
}

class MulticardModerationTextBanner(
    @JsonProperty("body")
    val body: String,
    @JsonProperty("title")
    val title: String,
    @JsonProperty("title_extension")
    val titleExtension: String?,
    @JsonProperty("href")
    val href: String?,
    @JsonProperty("domain")
    val domain: String?,
)

class MulticardModerationCpmVideoBanner(
    @JsonProperty("href")
    val href: String,
    @JsonProperty("domain")
    val domain: String?,
    @JsonProperty("creative_id")
    val creativeId: Long,
    @JsonProperty("creative_preview_url")
    val creativePreviewUrl: String,
    @JsonProperty("live_preview_url")
    val livePreviewUrl: String,
)

@JsonInclude(JsonInclude.Include.NON_NULL)
class BannerMulticardRequestData(
    @JsonProperty("multicard")
    val multicard: List<MulticardModerationDataItem>,
    @JsonProperty("banner_type")
    val bannerType: MulticardModerationBannerType,
    @JsonProperty("geo")
    val geo: String,
    @JsonProperty("text_banner")
    val textBanner: MulticardModerationTextBanner? = null,
    @JsonProperty("cpm_video_banner")
    val cpmVideoBanner: MulticardModerationCpmVideoBanner? = null,
) : BaseModerationData()

@JsonInclude(JsonInclude.Include.NON_NULL)
class BannerMulticardModerationRequest
    : BaseBannerModerationRequest<BannerAssetModerationMeta, BannerMulticardRequestData>()
